/*
	ruleset.h
*/

#ifndef _RULESET_H
#define _RULESET_H

#include "config.h"

/* See http://home.snafu.de/jasiek/korules.html */
enum {
	GO_RULESET_KO_NONE,
	GO_RULESET_KO_SIMPLE,
	GO_RULESET_KO_POSITIONAL_SUPERKO,
	GO_RULESET_KO_SITUATIONAL_SUPERKO
};

enum {
	GO_RULESET_HANDICAP_FREE,
	GO_RULESET_HANDICAP_FIXED
};

/* Shared komi: Japanese W+5.5 is Chinese B-2.75, W+2.75. */

/* Quantum go -- cool! http://www.tipjar.com/dnconsult/QuantumGo.htm.
   Copying policy -- uncool.

   Atari go. */

/* http://www.goban.demon.co.uk/go/main.html
   http://www.di.fc.ul.pt/~jpn/gv/gv.htm */

typedef struct go_ruleset go_ruleset;
struct go_ruleset {
	int pass_allowed;
	int suicide_allowed;
	int ko;
	int handicap_placement;
	int score_territory;
	int score_occupied_points;
	int score_captures;
	int score_passes;
	int play_on_colored_points;
	int simultaneous_capture;
	int othello_capture;
};

const go_ruleset go_ruleset_aga;

const go_ruleset go_ruleset_chinese;

const go_ruleset go_ruleset_japanese;

const go_ruleset go_ruleset_logical;

const go_ruleset go_ruleset_new_zealand;

int go_ruleset_cmp(const go_ruleset *a, const go_ruleset *b);

#endif
