/*
	ruleset.c
*/

#include "config.h"

#include "ruleset.h"

/*
struct go_ruleset {
	int pass_allowed;
	int suicide_allowed;
	int ko;
	int handicap;
	int score_territory;
	int score_occupied_points;
	int score_captures;
	int score_passes;
	int play_on_colored_points;
	int simultaneous_capture;
	int othello_capture;
};
*/

const go_ruleset go_ruleset_aga = {
	1,
	0,
	GO_RULESET_KO_SITUATIONAL_SUPERKO,
	GO_RULESET_HANDICAP_FREE,	/* Is this right? */
	1,
	1,
	0,
	1,
	0,
	0,
	0
};

const go_ruleset go_ruleset_chinese = {
	1,
	0,
	GO_RULESET_KO_POSITIONAL_SUPERKO,
	GO_RULESET_HANDICAP_FREE,
	1,
	1,
	0,
	0,
	0,
	0,
	0
};

const go_ruleset go_ruleset_japanese = {
	1,
	0,
	GO_RULESET_KO_SIMPLE,
	GO_RULESET_HANDICAP_FIXED,
	1,
	0,
	1,
	0,
	0,
	0,
	0
};

const go_ruleset go_ruleset_logical = {
	1,
	1,
	GO_RULESET_KO_POSITIONAL_SUPERKO,
	GO_RULESET_HANDICAP_FREE,
	1,
	1,
	0,
	0,
	0,
	0,
	0
};

const go_ruleset go_ruleset_new_zealand = {
	1,
	1,
	GO_RULESET_KO_POSITIONAL_SUPERKO,
	GO_RULESET_HANDICAP_FREE,
	1,
	1,
	0,
	0,
	0,
	0,
	0
};

/* This function is intended to provide a way to test how similar two
   rulesets are. Differences in rules will increase the returned value;
   differences in rules that have a greater effect on play will increase
   it more. */
int go_ruleset_cmp(const go_ruleset *a, const go_ruleset *b)
{
	int diff;

	diff = 0;
	if (a->pass_allowed != b->pass_allowed)
		diff += 50;
	if (a->suicide_allowed != b->suicide_allowed)
		diff += 30;
	if (a->ko != b->ko)
		diff += 5;
	if (a->handicap_placement != b->handicap_placement)
		diff += 10;
	if (a->score_territory != b->score_territory)
		diff += 20;
	if (a->score_occupied_points != b->score_occupied_points)
		diff += 10;
	if (a->score_captures != b->score_captures)
		diff += 10;
	if (a->score_passes != b->score_passes)
		diff += 5;
	if (a->play_on_colored_points != b->play_on_colored_points)
		diff += 100;
	if (a->simultaneous_capture != b->simultaneous_capture)
		diff += 100;
	if (a->othello_capture != b->othello_capture)
		diff += 100;

	return diff;
}
