/*
	terminal.h
*/

#ifndef _TERMINAL_H
#define _TERMINAL_H

#include "config.h"

#include "game.h"

typedef struct interface_state interface_state;
struct interface_state {
	unsigned int is_running;
	unsigned int update_display;
	unsigned int num_games;
	go_game *games;
	unsigned int current_game;
	unsigned int alternate_game;
	struct {
		int show_comments;
	} options;
};

extern char display_chars[];

int interface_terminal(int argc, char *argv[]);

interface_state *interface_state_init(interface_state *interface);

void interface_state_free(interface_state *interface);

go_game *interface_state_add_game(interface_state *interface, const go_game *game);

go_game *interface_state_remove_game(interface_state *interface, unsigned int index);

void interface_state_set_current_game(interface_state *interface, unsigned int index);

void interface_state_print(const interface_state *interface, FILE *fp);

void print_wrapped(FILE *fp, const char *text, const char *indent);

#endif
