/*
	menu.c
*/

#include "config.h"

#include <ctype.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <readline/readline.h>

#include "menu.h"

char display_menu(const menu_entry *menu)
{
	unsigned int i;
	int key;

	for (i = 0; menu[i].key != '\0'; i++) {
		if (menu[i].text != NULL)
			printf("%c. %s\n", menu[i].key, menu[i].text);
	}
	for (;;) {
		printf("Select: ");
		key = rl_read_key();
		for (i = 0; menu[i].key != '\0'; i++) {
			printf("%c - %c\n", menu[i].key, key);
			if (menu[i].key == key) {
				putchar('\n');
				break;
			}
		}
	}
	/*
	rl_stop_output(0, 0);
	rl_restart_output(0, 0);
	*/

	return i;
}

unsigned int show_menu(const char *prompt, ...)
{
	va_list ap;
	char *item, *number;
	unsigned int i, num_items;

	for (;;) {
		va_start(ap, prompt);
		for (num_items = 0; ; num_items++) {
			item = va_arg(ap, char *);
			if (item == NULL)
				break;
			printf("%u. %s\n", num_items + 1, item);
		}
		va_end(ap);
		rl_save_prompt();
		number = readline(prompt);
		rl_restore_prompt();
		if (number == NULL)
			return (unsigned int) -1;
		if ((sscanf(number, "%u", &i) != 1) || (i < 1) || (i > num_items)) {
			printf("Enter a number between 1 and %u\n", num_items);
			free(number);
		} else {
			free(number);
			break;
		}
	}

	return i - 1;
}
