/*
	commands.h
*/

#ifndef _COMMANDS_H
#define _COMMANDS_H

#include "config.h"

#include "terminal.h"

enum {
	MAX_RETURNED_COMMANDS = 5
};

typedef struct command command;
struct command {
	const char *name;
	interface_state *(*func)(interface_state *interface, const char *name, const char *args);
	const char *usage;
	const char *help;
};

void command_lookup(const char *name, const command **results, unsigned int *num_results, unsigned int max_results);

char *get_word(const char **s);

interface_state *command_back(interface_state *interface, const char *name, const char *args);

interface_state *command_close(interface_state *interface, const char *name, const char *args);

interface_state *command_color(interface_state *interface, const char *name, const char *args);

interface_state *command_dead(interface_state *interface, const char *name, const char *args);

interface_state *command_comment(interface_state *interface, const char *name, const char *args);

interface_state *command_display(interface_state *interface, const char *name, const char *args);

interface_state *command_forward(interface_state *interface, const char *name, const char *args);

interface_state *command_games(interface_state *interface, const char *name, const char *args);

interface_state *command_help(interface_state *interface, const char *name, const char *args);

interface_state *command_label(interface_state *interface, const char *name, const char *args);

interface_state *command_last(interface_state *interface, const char *name, const char *args);

interface_state *command_load(interface_state *interface, const char *name, const char *args);

interface_state *command_mark(interface_state *interface, const char *name, const char *args);

interface_state *command_move(interface_state *interface, const char *name, const char *args);

interface_state *command_new(interface_state *interface, const char *name, const char *args);

interface_state *command_pass(interface_state *interface, const char *name, const char *args);

interface_state *command_players(interface_state *interface, const char *name, const char *args);

interface_state *command_quit(interface_state *interface, const char *name, const char *args);

interface_state *command_resign(interface_state *interface, const char *name, const char *args);

interface_state *command_rewind(interface_state *interface, const char *name, const char *args);

interface_state *command_save(interface_state *interface, const char *name, const char *args);

interface_state *command_score(interface_state *interface, const char *name, const char *args);

interface_state *command_select(interface_state *interface, const char *name, const char *args);

interface_state *command_switch(interface_state *interface, const char *name, const char *args);

interface_state *command_undo(interface_state *interface, const char *name, const char *args);

interface_state *command_variation(interface_state *interface, const char *name, const char *args);

#endif
