/*
	board.h
*/

#ifndef _BOARD_H
#define _BOARD_H

#include "config.h"

typedef struct go_point go_point;
struct go_point {
	unsigned int color;
	unsigned int num_adjacent;
	unsigned int *adjacent;
	unsigned int string_index;
	unsigned int string_next;
};

typedef struct go_string go_string;
struct go_string {
	unsigned int size;
	unsigned int point_index;
	unsigned int num_neighbors;
	unsigned int *neighbors;
};

typedef struct go_board go_board;
struct go_board {
	unsigned int num_points;
	go_point *points;
	unsigned int num_strings;
	go_string *strings;
	unsigned int new_string;
};

go_point *go_point_init(go_point *point);

void go_point_free(go_point *point);

go_string *go_string_init(go_string *string);

void go_string_free(go_string *string);

go_board *go_board_init(go_board *board);

void go_board_free(go_board *board);

go_board *go_board_set_num_points(go_board *board, unsigned int num_points);

go_board *go_board_add_point(go_board *board);

go_board *go_board_remove_point(go_board *board, unsigned int index);

go_board *go_board_connect_points(go_board *board, unsigned int a, unsigned int b);

go_board *go_board_disconnect_points(go_board *board, unsigned int a, unsigned int b);

go_board *go_board_calculate_strings(go_board *board);

go_board *go_board_color_point(go_board *board, unsigned int index, unsigned int color);

go_board *go_board_color_string(go_board *board, unsigned int index, unsigned int color);

int go_board_point_reaches_color(const go_board *board, unsigned int index, unsigned int color);

int go_board_string_reaches_color(const go_board *board, unsigned int index, unsigned int color);

int go_board_string_reaches_one_color(const go_board *board, unsigned int index);

int go_board_string_contains_point(const go_board *board, unsigned int string_index, unsigned int point_index);

/*
void go_board_print_dot(const go_board *board, FILE *fp);

void go_board_print_strings(const go_board *board, FILE *fp);

void go_board_print_strings_rectangular(const go_board *board, FILE *fp, unsigned int width, unsigned int height);
*/

#endif
