/*
	array.h
*/

#ifndef _ARRAY_H
#define _ARRAY_H

#include "config.h"

#include <stddef.h>

void array_init(void **array, unsigned int *num);

void array_free(void **array, unsigned int *num, size_t size, void (*f)(void *));

void *array_duplicate(void **array, unsigned int *num, size_t size, const void *from, unsigned int from_num, void *(*duplicate)(void *, const void *));

void array_apply(void **array, unsigned int *num, size_t size, void (*f)(void *, void *), void *data);

void array_sort(void **array, const unsigned int *num, size_t size, int (*cmp)(const void *, const void *));

void *array_search(const void **array, const unsigned int *num, size_t size, const void *element, int (*cmp)(const void *, const void *));

void *array_insert_index(void **array, unsigned int *num, size_t size, const void *element, unsigned int index);

void *array_remove_index(void **array, unsigned int *num, size_t size, unsigned int index);

void *array_remove_index_keep_order(void **array, unsigned int *num, size_t size, unsigned int index);

void *array_insert(void **array, unsigned int *num, size_t size, const void *element, int (*cmp)(const void *, const void *));

void *array_insert_no_duplicates(void **array, unsigned int *num, size_t size, const void *element, int (*cmp)(const void *, const void *));

void *array_remove(void **array, unsigned int *num, size_t size, const void *element, int (*cmp)(const void *, const void *));

void *array_remove_keep_order(void **array, unsigned int *num, size_t size, const void *element, int (*cmp)(const void *, const void *));

void *array_search_sorted(const void **array, const unsigned int *num, size_t size, const void *element, int (*cmp)(const void *, const void *));

void *array_insert_sorted(void **array, unsigned int *num, size_t size, const void *element, int (*cmp)(const void *, const void *));

void *array_insert_sorted_no_duplicates(void **array, unsigned int *num, size_t size, const void *element, int (*cmp)(const void *, const void *));

void *array_remove_sorted(void **array, unsigned int *num, size_t size, const void *element, int (*cmp)(const void *, const void *));

#endif
