#include <ctype.h>
#include <stdio.h>
#include <time.h>

int isupper_space(int c);
int isupper_time(int c);

#define COUNT 10000000L

main(int argc, char *argv)
{
	struct {
		char *name;
		int (*func)(int);
	} tries[] = {
		"isupper_space", isupper_space,
		"isupper_time", isupper_time,
		"library isupper", isupper
	};
	int c, i;
	long count;
	clock_t start, end;

	for (i = 0; i < sizeof(tries) / sizeof(*tries); i++) {
		start = clock();
		for (count = COUNT; count > 0; count--)
			tries[i].func('A');
		end = clock();
		printf("%s: %f s\n", tries[i].name,
			(double) (end - start) / CLOCKS_PER_SEC);
	}
}

int isupper_space(int c)
{
	return c != EOF && c >= 'A' && c <= 'Z';
}

const static int time_tab[256] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
};

int isupper_time(int c)
{
	return c != EOF && time_tab[c];
}
